%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function [inverted] = evalquality2(mesh,filebase,flag,fillflag);

n=length(mesh.tris);

area = zeros(n,1);
angle = zeros(n,3);
cond_num = zeros(n,1);
mean_ratio = zeros(n,1);
aspect_ratio = zeros(n,1);

% Compute Quality Metrics

for i=1:n

  node1 = mesh.tris(i,1);
  node2 = mesh.tris(i,2);
  node3 = mesh.tris(i,3);
  x1 = mesh.coords(node1,1);
  x2 = mesh.coords(node2,1);
  x3 = mesh.coords(node3,1);
  y1 = mesh.coords(node1,2);
  y2 = mesh.coords(node2,2);
  y3 = mesh.coords(node3,2);

  coords = struct('x1',x1,'y1',y1,'x2',x2,'y2',y2,'x3',x3,'y3',y3);

  area(i) = compute_area2(coords);
  [angle(i,:)] = compute_angles2(coords);
  cond_num(i) = compute_cond_num2(coords);
  mean_ratio(i) = compute_mean_ratio2(coords);
  aspect_ratio(i) = compute_aspect_ratio2(coords);

end;  

inverted = 0;

for (i=1:length(mean_ratio))
  if (mean_ratio(i) < 0)
    inverted = inverted+1;
    if (fillflag)
      
      node1 = mesh.tris(i,1);
      node2 = mesh.tris(i,2);
      node3 = mesh.tris(i,3);
      x=[mesh.coords(node1,1) mesh.coords(node2,1) mesh.coords(node3,1)];
      y=[mesh.coords(node1,2) mesh.coords(node2,2) mesh.coords(node3,2)];
            
      fill(x,y,'g');
    end;
  end;
end;

% Find min, max, avg for each quality metric over entire mesh.

min_area = min(area);
max_area = max(area);
avg_area = mean(area);

min_angle = min(min(angle,[],1));
max_angle = max(max(angle,[],1));
avg_angle = mean(mean(angle,1));

min_cond_num = min(cond_num);
max_cond_num = max(cond_num);
avg_cond_num = mean(cond_num);

min_mean_ratio = min(mean_ratio);
max_mean_ratio = max(mean_ratio);
avg_mean_ratio = mean(mean_ratio);

min_aspect_ratio = min(aspect_ratio);
max_aspect_ratio = max(aspect_ratio);
avg_aspect_ratio = mean(aspect_ratio);

% Print Quality Information to File

filename = sprintf('%s.quality',filebase);
file = fopen(filename,'a');

s = sprintf('%s','********************************************************');
fprintf(file,'%s \n',s);

title = sprintf('%s','Mesh Quality Statistics:  ');

if (flag==1)
  meshtype = sprintf('%s','Initial Mesh');
elseif (flag==2)
  meshtype = sprintf('%s','Tangled Mesh');
elseif (flag==3)
  meshtype = sprintf('%s','Untangled Mesh');
else
  meshtype = sprintf('%s','Smoothed Mesh');
end;

fprintf(file,'%s %s\n\n',title,meshtype);

s = sprintf('%s','min, max, avg area = ');
fprintf(file,'%s %.4f %.4f %.4f\n',s,min_area,max_area,avg_area);

s = sprintf('%s','min, max, avg angle = ');
fprintf(file,'%s %.4f %.4f %.4f\n',s,min_angle,max_angle,avg_angle);

s = sprintf('%s','min, max, avg condition number = ');
fprintf(file,'%s %.4f %.4f %.4f\n',s,min_cond_num,max_cond_num,avg_cond_num);

s = sprintf('%s','min, max, avg mean ratio = ');
fprintf(file,'%s %.4f %.4f %.4f\n',s,min_mean_ratio,max_mean_ratio,avg_mean_ratio);

s = sprintf('%s','min, max, avg aspect ratio = ');
fprintf(file,'%s %.4f %.4f %.4f\n',s,min_aspect_ratio,max_aspect_ratio,avg_aspect_ratio);

s = sprintf('%s','********************************************************');
fprintf(file,'%s \n\n',s);

if (flag==4)
  fclose(file);
end;
